<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die;

/**
 * Script file of the LatestNewsEnhanced module
 */
class mod_latestnewsenhancedInstallerScript
{	
	static $minimum_needed_library_version = '1.0.6';
	static $download_link = 'http://www.simplifyyourweb.com/index.php/downloads/category/23-libraries';
	
	/**
	 * Called before an install/update/uninstall method
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($type, $parent) {
		
	}
	
	/**
	 * Called after an install/update/uninstall method
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function postflight($type, $parent) 
	{		
		// delete unnecessary files
		
		$files = array(
			'/modules/mod_latestnewsenhanced/helper.php',
			'/modules/mod_latestnewsenhanced/image.php',
			'/modules/mod_latestnewsenhanced/style_msie_7.css.php',
			'/modules/mod_latestnewsenhanced/helpers/image.php',
			'/modules/mod_latestnewsenhanced/fields/gdtest.php',
			'/modules/mod_latestnewsenhanced/fields/k2category.php',
			'/modules/mod_latestnewsenhanced/fields/k2test.php',
			'/modules/mod_latestnewsenhanced/fields/message.php',
			'/modules/mod_latestnewsenhanced/js/jquerynoconflict.js'
		);
		
		$folders = array(
			'/modules/mod_latestnewsenhanced/fields/gdtest'
		);
		
		jimport('joomla.filesystem.file');
		foreach ($files as $file) {
			if (JFile::exists(JPATH_ROOT.$file) && !JFile::delete(JPATH_ROOT.$file)) {
				echo JText::sprintf('FILES_JOOMLA_ERROR_FILE_FOLDER', $file).'<br />';
			}
		}
		
		jimport('joomla.filesystem.folder');
		foreach ($folders as $folder) {
			if (JFolder::exists(JPATH_ROOT.$folder) && !JFolder::delete(JPATH_ROOT.$folder)) {
				echo JText::sprintf('FILES_JOOMLA_ERROR_FILE_FOLDER', $folder).'<br />';
			}
		}
		
		// check if syw library is present
		
		$version = new JVersion();
		$jversion = explode('.', $version->getShortVersion());
		
		$class = '';
		$style = '';
		
		if (intval($jversion[0]) > 2) {
			$class = 'alert alert-warning';
		} else {
			$style = 'margin: 5px 0; padding: 8px 35px 8px 14px; border-radius: 4px; border: 1px solid #FBEED5; background-color: #FCF8E3; color: #C09853;';
		}
		
		if (!JFolder::exists(JPATH_ROOT.'/libraries/syw')) {			
			echo '<div class="'.$class.'" style="'.$style.'">';
			echo '    <span>'.JText::_('SYW_MISSING_SYWLIBRARY').'</span><br />';
			echo '    <a href="'.self::$download_link.'" target="_blank">'.JText::_('SYW_DOWNLOAD_SYWLIBRARY').'</a>';
			echo '</div>';
		} else {
			jimport('syw.version');			
			if (SYWVersion::isCompatible(self::$minimum_needed_library_version)) {				
				if (intval($jversion[0]) > 2) {
					$class = 'alert alert-success';
				} else {
					$style = 'margin: 5px 0; padding: 8px 35px 8px 14px; border-radius: 4px; border: 1px solid #D6E9C6; background-color: #DFF0D8; color: #468847;';
				}				
				echo '<div class="'.$class.'" style="'.$style.'">';
				echo '    <span>'.JText::_('SYW_COMPATIBLE_SYWLIBRARY').'</span>';
				echo '</div>';
			} else {
				echo '<div class="'.$class.'" style="'.$style.'">';
				echo '    <span>'.JText::_('SYW_NONCOMPATIBLE_SYWLIBRARY').'</span><br />';
				echo '    <span>'.JText::_('SYW_UPDATE_SYWLIBRARY').JText::_('SYW_OR').'</span>';
				echo '    <a href="'.self::$download_link.'" target="_blank">'.strtolower(JText::_('SYW_DOWNLOAD_SYWLIBRARY')).'</a>';
				echo '</div>';
			}
		}	
		
		return true;
	}	
	
	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install($parent) {
		
	}
	
	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update($parent) {
		
	}
	
	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	public function uninstall($parent) {
		
	}
}
?>